import pandas as pd  
import pickle 
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")  

# Identify additional customer segments with potential for responsiveness to promotions and financing options   
# Criteria: customers with a good credit history and a high credit amount 
good_credit_history = credit_customers['credit_history'].isin(['no credits/all paid'])   
high_credit_amount = credit_customers['credit_amount'] > credit_customers['credit_amount'].quantile(0.75)   

# Combine the filters and apply them to the dataset   
potential_customers = credit_customers[good_credit_history & high_credit_amount]   

# Extract the additional customer segments   
additional_customer_segments = potential_customers['cluster'].unique().tolist() 

print("additional_customer_segments:\n", additional_customer_segments)    
pickle.dump(additional_customer_segments,open("./ref_result/additional_customer_segments.pkl","wb"))